/*
 * Decompiled with CFR 0.152.
 */
package io.sigpipe.jbsdiff.ui;

import io.sigpipe.jbsdiff.ui.FileUI;
import java.io.File;

public class CLI {
    private static final String COMMAND_DIFF = "diff";
    private static final String COMMAND_PATCH = "patch";

    private CLI() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 3) {
            args = CLI.withCommandGuess(args);
        }
        if (args.length < 4) {
            System.out.println("Not enough parameters!");
            CLI.printUsage();
        }
        String compression = System.getProperty("jbsdiff.compressor", "bzip2");
        compression = compression.toLowerCase();
        try {
            String command = args[0].toLowerCase();
            File oldFile = new File(args[1]);
            File newFile = new File(args[2]);
            File patchFile = new File(args[3]);
            if (COMMAND_DIFF.equals(command)) {
                FileUI.diff(oldFile, newFile, patchFile, compression);
            } else if (COMMAND_PATCH.equals(command)) {
                FileUI.patch(oldFile, newFile, patchFile);
            } else {
                CLI.printUsage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void printUsage() {
        String usage = String.format("Usage: command <oldfile> <newfile> <patchfile>%n%nCommands:%n    diff%n    patch%n%nUse the jbsdiff.compressor property to select a different compression scheme:%n    java -Djbsdiff.compressor=gz -jar jbsdiff-*.jar diff a.bin b.bin patch.gz%n%nSupported compression schemes: bzip2 (default), gz, pack200, xz.%n%nThe compression algorithm used will be detected automatically during %npatch operations.  NOTE: algorithms other than bzip2 are incompatible %nwith the reference implementation of bsdiff!", new Object[0]);
        System.out.println(usage);
        System.exit(1);
    }

    private static String[] withCommandGuess(String[] args) {
        if (args.length != 3) {
            return args;
        }
        if (COMMAND_DIFF.equals(args[0]) || COMMAND_PATCH.equals(args[0])) {
            return args;
        }
        File oldFile = new File(args[0]);
        File newFile = new File(args[1]);
        File patchFile = new File(args[2]);
        String actionTemplate = "Guessing! %s %s & %s AS %s";
        if (oldFile.exists() && newFile.exists() && !patchFile.exists()) {
            String command = COMMAND_DIFF;
            String chosenAction = String.format(actionTemplate, command, oldFile, newFile, patchFile);
            System.out.println(chosenAction);
            args = CLI.insertCommand(command, args);
        } else if (oldFile.exists() && patchFile.exists() && !newFile.exists()) {
            String command = COMMAND_PATCH;
            String chosenAction = String.format(actionTemplate, command, oldFile, patchFile, newFile);
            System.out.println(chosenAction);
            args = CLI.insertCommand(command, args);
        }
        return args;
    }

    private static String[] insertCommand(String command, String[] args) {
        String[] withCommand = new String[args.length + 1];
        withCommand[0] = command;
        for (int i = 0; i < args.length; ++i) {
            withCommand[i + 1] = args[i];
        }
        return withCommand;
    }
}

